// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `until` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Until {
    /// Condition of the loop
    pub cond: Box<Node>,

    /// Body of the loop.
    ///
    /// `None` if body is empty
    pub body: Option<Box<Node>>,

    /// Location of the `until` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    ///            ~~
    /// ```
    ///
    /// `do` is optional, and so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    ///                     ~~~
    /// ```
    ///
    /// `None` if loop is a modifier (i.e. `foo until bar`)
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// until cond do; foo; end
    /// ~~~~~~~~~~~~~~~~~~~~~~~
    ///
    /// foo until bar
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Until {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_maybe_node_or_nil(&self.body);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "until"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
