// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `true` literal
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct True {
    /// Location of the `true` keyword
    ///
    /// ```text
    /// true
    /// ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for True {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "true"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
