// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a method call (e.g. `foo.bar(42)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Send {
    /// Receiver of the method call
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub recv: Option<Box<Node>>,

    /// Name of the method that is called
    pub method_name: String,

    /// A list of arguments
    pub args: Vec<Node>,

    /// Location of the `.` operator
    ///
    /// ```text
    /// foo.bar(42)
    ///    ~
    /// ```
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub dot_l: Option<Loc>,

    /// Location of the method name
    ///
    /// ```text
    /// foo.bar(42)
    ///     ~~~
    /// ```
    ///
    /// `None` in a very special case when method call is implicit (i.e. `foo.(42)`)
    pub selector_l: Option<Loc>,

    /// Location of open parenthesis
    ///
    /// ```text
    /// foo(42)
    ///    ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of closing parenthesis
    ///
    /// ```text
    /// foo(42)
    ///       ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the operator if method is a setter
    ///
    /// ```text
    /// foo.bar = 42
    ///         ~
    /// ```
    ///
    /// `None` otherwise
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo.bar(42)
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Send {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.recv);
        result.push_str(&self.method_name);
        result.push_nodes(&self.args);






        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "send"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.recv.as_ref() { node.inner_ref().print_with_locs() }

        for node in self.args.iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.dot_l.as_ref() { loc.print("dot") }
        if let Some(loc) = self.selector_l.as_ref() { loc.print("selector") }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
