// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a single `rescue` handler (i.e. `rescue E => e ...`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct RescueBody {
    /// A list of exception classes
    ///
    /// `None` if no classes specified (i.e. `rescue => e; ...` or just `rescue; ...`)
    pub exc_list: Option<Box<Node>>,

    /// Variable that captures exception
    ///
    /// `None` if no variable specified (i.e. `rescue E; ...` or just `rescue; ... `)
    pub exc_var: Option<Box<Node>>,

    /// Body of the handler
    pub body: Option<Box<Node>>,

    /// Location of the `rescue` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///           ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///                    ~~
    /// ```
    ///
    /// `None` if exception is not captured.
    pub assoc_l: Option<Loc>,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///                         ~~~~
    /// ```
    ///
    /// `then` is optional, so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///           ~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for RescueBody {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.exc_list);
        result.push_maybe_node_or_nil(&self.exc_var);
        result.push_maybe_node_or_nil(&self.body);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "resbody"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.exc_list.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.exc_var.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        if let Some(loc) = self.assoc_l.as_ref() { loc.print("assoc") }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        self.expression_l.print("expression");
    }
}
