// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents regex literal (e.g. `/foo/`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Regexp {
    /// A list of static and dynamic regex parts
    pub parts: Vec<Node>,

    /// Regex options.
    ///
    /// `None` if regex has no explicit flags
    pub options: Option<Box<Node>>,

    /// Location of the regex begin
    ///
    /// ```text
    /// /foo/
    /// ~
    ///
    /// %r{foo}
    /// ~~
    /// ```
    pub begin_l: Loc,

    /// Location of the regex end
    ///
    /// ```text
    /// /foo/
    ///     ~
    ///
    /// %r{foo}
    ///       ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// /foo/mix
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Regexp {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.parts);
        result.push_regex_options(&self.options);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regexp"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.parts.iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.options.as_ref() { node.inner_ref().print_with_locs() }
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
