// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `BEGIN { ... }` statement
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Preexe {
    /// Body of the block
    pub body: Option<Box<Node>>,

    /// Location of the `BEGIN` keyword
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///       ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Preexe {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(&self.body);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "preexe"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
