// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents numeric global variable (e.g. `$1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct NthRef {
    /// Name of the variable, `String("1")` for `$1`
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// $1
    /// ~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for NthRef {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_raw_str(&self.name);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nth_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.expression_l.print("expression");
    }
}
