// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents left hand statement of the mass-assignment (i.e. `foo, bar` in `foo, bar = 1, 2`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Mlhs {
    /// A list of items that are assigned
    pub items: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// (a, b) = 1, 2
    /// ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// (a, b) = 1, 2
    ///      ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// (a, b) = 1, 2
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Mlhs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.items);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "mlhs"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.items.iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
