// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents matching with assignment into a local variable (i.e. `pattern => var`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchVar {
    /// Name of the variable that is assigned if matching succeeds
    pub name: String,

    /// Location of the name
    ///
    /// ```text
    /// case foo; in pattern => bar; end
    ///                         ~~~
    /// ```
    ///
    /// **Note** it can also be produced by a hash pattern
    ///
    /// ```text
    /// case foo; in { a: }; end
    ///                ~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in pattern => bar; end
    ///                         ~~~
    /// ```
    ///
    /// **Note** it can also be produced by a hash pattern
    ///
    /// ```text
    /// case foo; in { a: }; end
    ///                ~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for MatchVar {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_var"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
