// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents matching with renaming into specified local variable (i.e. `case 1; in Integer => a; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchAs {
    /// Pattern that is used for matching
    pub value: Box<Node>,

    /// Variable that is assigned if matched (see `MatchVar` node)
    pub as_: Box<Node>,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///                    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///            ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for MatchAs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.value);
        result.push_node(&self.as_);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_as"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.inner_ref().print_with_locs();
        self.as_.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
