// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents inclusive range (i.e. `2..4`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Irange {
    /// Begin of the range, `None` if range has no `begin` (i.e. `..4`)
    pub left: Option<Box<Node>>,

    /// End of the range, `None` if range has no `end` (i.e. `2..`)
    pub right: Option<Box<Node>>,

    /// Location of the `..` operator
    ///
    /// ```text
    /// 2..4
    ///  ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// 2..4
    /// ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Irange {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.left);
        result.push_maybe_node_or_nil(&self.right);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "irange"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.left.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.right.as_ref() { node.inner_ref().print_with_locs() }
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
