// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents assignment using indexing operation (i.e. `foo[1, 2, 3] = bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IndexAsgn {
    /// Receiver of the indexing
    pub recv: Box<Node>,

    /// A list of indexes
    pub indexes: Vec<Node>,

    /// Value that is assigned
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case `value` belongs to `Masgn` node.
    pub value: Option<Box<Node>>,

    /// Location of open bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///    ~
    /// ```
    pub begin_l: Loc,

    /// Location of closing bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///              ~
    /// ```
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case operator `=` belongs to `Masgn` node.
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for IndexAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_nodes(&self.indexes);
        result.push_maybe_node(&self.value);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "indexasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        for node in self.indexes.iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.value.as_ref() { node.inner_ref().print_with_locs() }
        self.begin_l.print("begin");
        self.end_l.print("end");
        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
