// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if` guard used in pattern matching (i.e. `case foo; in pattern if guard; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfGuard {
    /// Condition of the guard, `Lvar("foo")` in `in pattern if guard`
    pub cond: Box<Node>,

    /// Location of the `if` keyword
    ///
    /// ```text
    /// case foo; in pattern if cond; end
    ///                      ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in pattern if cond; end
    ///                      ~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for IfGuard {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if_guard"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
