// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a find pattern using in pattern matching (i.e. `in [*x, 1 => a, *y]`)
///
/// It's different from `ArrayPattern`/`ConstPattern` because it supports multiple wildcard pattern
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct FindPattern {
    /// Inner part of the find pattern
    pub elements: Vec<Node>,

    /// Location of the begin
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///              ~
    /// ```
    ///
    /// `None` if there are no brackets/parentheses
    pub begin_l: Option<Loc>,

    /// Location of the end
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///                             ~
    /// ```
    ///
    /// `None` if there are no brackets/parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///              ~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for FindPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.elements);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "find_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.elements.iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
