// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `Complex` literal (that returns an `Complex` number)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Complex {
    /// Value of the complex literal, returned as a `String`, `String("1i")` for `1i`
    pub value: String,

    /// Location of the `-` (but not `+`) operator. `+` is a part of the literal:
    /// 1. `+1i` is `String("+1i")` with `operator = None`
    /// 2. `-1i` is `String("1i")` with `operator = String("-")`
    ///
    /// ```text
    /// -1i
    /// ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// -1i
    /// ~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Complex {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.value);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "complex"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
