// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `&blk` argument in the method definition (but not in the method call, see `BlockPass`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Blockarg {
    /// Name of the argument, `String("foo")` for `def m(&foo)`
    pub name: String,

    /// Location of the `&` operator
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// def m(&foo); end
    ///        ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Blockarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "blockarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.operator_l.print("operator");
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
