// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a Ruby block that is passed to a method (`proc { |foo| bar }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Block {
    /// Method call that takes a block
    ///
    /// `Send("foo")` in `foo {}`
    pub call: Box<Node>,

    /// A list of argument that block takes
    ///
    /// `vec![ Arg("a"), Optarg("b", Int("1")) ]` for `proc { |a, b = 1| }`
    ///
    /// `None` if the block takes no arguments
    pub args: Option<Box<Node>>,

    /// Block body, `None` if block has no body.
    pub body: Option<Box<Node>>,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { }
    ///      ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing brace
    ///
    /// ```text
    /// proc { }
    ///        ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// proc { }
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Block {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.call);
        result.push_maybe_node_or_nil(&self.args);
        result.push_maybe_node_or_nil(&self.body);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.call.inner_ref().print_with_locs();
        if let Some(node) = self.args.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
