// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a positional required block/method argument.
///
/// `a` in `def m(a); end` or `proc { |a| }`
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Arg {
    /// Name of the argument
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(argument); end
    ///       ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Arg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "arg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.expression_l.print("expression");
    }
}
