// This file is auto-generated by codegen/rust/messages.rs

/// Enum of all possible diagnostic message (both warnings and errors)
#[derive(Debug, Clone, PartialEq, Eq)]
#[allow(missing_docs)]
#[repr(C)]
pub enum DiagnosticMessage {
    /// Emitted for code
    /// ```text
    /// 1.2.3
    /// ```
    FractionAfterNumeric {

    },
    /// Emitted for code like
    /// ```text
    /// foo.2
    /// ```
    NoDigitsAfterDot {

    },
    /// Emitted for code like
    /// ```text
    /// %k[foo]
    /// ```
    UnknownTypeOfPercentString {

    },
    /// Emitted for code like
    /// ```text
    /// 0b
    /// ```
    NumericLiteralWithoutDigits {

    },
    /// Emitted for code like
    /// ```text
    /// %w[foo bar
    /// ```
    UnterminatedList {

    },
    /// Emitted for code like
    /// ```text
    /// /foo
    /// ```
    UnterminatedRegexp {

    },
    /// Emitted for code like
    /// ```text
    /// "foo
    /// ```
    UnterminatedString {

    },
    /// Emitted for code like
    /// ```text
    /// %s
    /// //    ^ EOF, not "
    ///
    /// ```
    UnterminatedQuotedString {

    },
    /// Emitted for code like
    /// ```text
    /// "\ufoo"
    /// ```
    InvalidUnicodeEscape {

    },
    /// Emitted for code like
    /// ```text
    /// "\u{999999}"
    /// ```
    TooLargeUnicodeCodepoint {

    },
    /// Emitted for code like
    /// ```text
    /// "\u{d800}"
    /// ```
    InvalidUnicodeCodepoint {

    },
    /// Emitted for code like
    /// ```text
    /// ?\u{41 42}
    /// ```
    MultipleCodepointAtSingleChar {

    },
    /// Emitted for code like
    /// ```text
    /// "\M-"
    /// ```
    InvalidEscapeCharacter {

    },
    /// Emitted for code like
    /// ```text
    /// "\xZZ"
    /// ```
    InvalidHexEscape {

    },
    /// Emitted for code like
    /// ```text
    /// <<-HERE
    /// ```
    UnterminatedHeredoc {
        /// Heredoc identifier
        heredoc_id: String,
    },
    /// Emitted for code like
    /// ```text
    /// <<-"HERE
    /// ```
    UnterminatedHeredocId {

    },
    /// Emitted for code like
    /// ```text
    /// eval("foo \r = 42")
    /// ```
    SlashRAtMiddleOfLine {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// foo **arg
    /// ```
    DStarInterpretedAsArgPrefix {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// foo *arg
    /// ```
    StarInterpretedAsArgPrefix {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// foo &arg
    /// ```
    AmpersandInterpretedAsArgPrefix {

    },
    /// Emitted for code like
    /// ```text
    /// range = 1...
    /// ```
    TripleDotAtEol {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// def m (a, b, c); end
    /// ```
    ParenthesesIterpretedAsArglist {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// m +foo
    /// ```
    AmbiguousFirstArgument {
        /// Operator that is ambiguous
        operator: u8,
    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// 1 *2
    /// ```
    AmbiguousOperator {
        /// Operator that is ambiguous
        operator: String,         /// Interpretation of this operator
        interpreted_as: String,
    },
    /// Emitted for code like
    /// ```text
    /// "\M- "
    /// ```
    InvalidCharacterSyntax {
        /// Valid syntax sugestions
        suggestion: String,
    },
    /// Emitted for code like
    /// ```text
    /// 09
    /// ```
    InvalidOctalDigit {

    },
    /// Emitted for code like
    /// ```text
    /// 0_a
    /// ```
    TrailingCharInNumber {
        /// Invalid trailing char
        c: u8,
    },
    /// Emitted for code like
    /// ```text
    /// =begin
    /// ```
    EmbeddedDocumentMeetsEof {

    },
    /// Emitted for code like
    /// ```text
    /// eval("\x01foo")
    /// ```
    InvalidChar {
        /// char
        c: u8,
    },
    /// It is unknown how to trigger this error.
    /// Code that triggers it in MRI can be dead.
    IncompleteCharacterSyntax {

    },
    /// Emitted for code like
    /// ```text
    /// $
    /// ```
    GvarWithoutId {

    },
    /// Emitted for code like
    /// ```text
    /// $@
    /// ```
    InvalidGvarName {
        /// char after `$`
        c: u8,
    },
    /// Emitted for code like
    /// ```text
    /// @
    /// ```
    IvarWithoutId {

    },
    /// Emitted for code like
    /// ```text
    /// @1
    /// ```
    InvalidIvarName {
        /// char after `@`
        c: u8,
    },
    /// Emitted for code like
    /// ```text
    /// @@
    /// ```
    CvarWithoutId {

    },
    /// Emitted for code like
    /// ```text
    /// @@1
    /// ```
    InvalidCvarName {
        /// char after `@@`
        c: u8,
    },
    /// Emitted for code like
    /// ```text
    /// /re/foo
    /// ```
    UnknownRegexOptions {
        /// Concatenated unknown options
        options: String,
    },
    /// Emitted for code like
    /// ```text
    /// "\u{1234"
    /// ```
    UnterminatedUnicodeEscape {

    },
    /// Emitted for code like
    /// ```text
    /// # encoding: foo
    /// ```
    EncodingError {
        /// Error from decoder
        error: String,
    },
    /// Emitter for code like
    /// ```text
    /// eval("\xFF = 42")
    /// ```
    InvalidMultibyteChar {

    },
    /// Emitted for code like
    /// ```text
    /// a ?AA : 2
    /// ```
    AmbiguousTernaryOperator {
        /// Source of the condition expression
        condition: String,
    },
    /// Emitted for code like
    /// ```text
    /// m /foo/
    /// ```
    AmbiguousRegexp {

    },
    /// Emitted for code like
    /// ```text
    /// begin; else; end
    /// ```
    ElseWithoutRescue {

    },
    /// Emitted for code like
    /// ```text
    /// def f; BEGIN{}; end
    /// ```
    BeginNotAtTopLevel {

    },
    /// Emitted for code like
    /// ```text
    /// alias $a $1
    /// ```
    AliasNthRef {

    },
    /// Emitted for code like
    /// ```text
    /// *a&.x = 0
    /// ```
    CsendInsideMasgn {

    },
    /// Emitted for code like
    /// ```text
    /// module foo; end
    /// ```
    ClassOrModuleNameMustBeConstant {

    },
    /// Emitted for code like
    /// ```text
    /// def foo=() = 42
    /// ```
    EndlessSetterDefinition {

    },
    /// Emitted for any code that produces invalid sequence of tokens
    UnexpectedToken {
        /// Name of the token
        token_name: String,
    },
    /// Emitted for code like
    /// ```text
    /// def a; class Foo; end; end
    /// ```
    ClassDefinitionInMethodBody {

    },
    /// Emitted for code like
    /// ```text
    /// def a; module Foo; end; end
    /// ```
    ModuleDefinitionInMethodBody {

    },
    /// Emitted for code like
    /// ```text
    /// class A; return; end
    /// ```
    InvalidReturnInClassOrModuleBody {

    },
    /// Emitted for code like
    /// ```text
    /// def foo(Abc); end
    /// ```
    ConstArgument {

    },
    /// Emitted for code like
    /// ```text
    /// def foo(@abc); end
    /// ```
    IvarArgument {

    },
    /// Emitted for code like
    /// ```text
    /// def foo($abc); end
    /// ```
    GvarArgument {

    },
    /// Emitted for code like
    /// ```text
    /// def foo(@@abc); end
    /// ```
    CvarArgument {

    },
    /// Emitted for code like
    /// ```text
    /// case 0; in ^a; true; end
    /// ```
    NoSuchLocalVariable {
        /// Variable name
        var_name: String,
    },
    /// Emitted for code like
    /// ```text
    /// m { |a| _1 }
    /// ```
    OrdinaryParamDefined {

    },
    /// Emitted for code like
    /// ```text
    /// foo { _1; bar { _2 }; }
    /// ```
    NumparamUsed {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// if
    /// 42
    /// end
    /// ```
    TokAtEolWithoutExpression {
        /// Name of the token
        token_name: String,
    },
    /// Emitted for code like
    /// ```text
    /// def m; END {}; end
    /// ```
    EndInMethod {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// a < b < c
    /// ```
    ComparisonAfterComparison {
        /// Source of the first comparison
        comparison: String,
    },
    /// Emitted for code like
    /// ```text
    /// def m(foo = foo) end
    /// ```
    CircularArgumentReference {
        /// Name of the argument
        arg_name: String,
    },
    /// Emitted for code like
    /// ```text
    /// def m; FOO = 1; end
    /// ```
    DynamicConstantAssignment {

    },
    /// Emitted for code like
    /// ```text
    /// self = foo
    /// ```
    CantAssignToSelf {

    },
    /// Emitted for code like
    /// ```text
    /// nil = foo
    /// ```
    CantAssignToNil {

    },
    /// Emitted for code like
    /// ```text
    /// true = foo
    /// ```
    CantAssignToTrue {

    },
    /// Emitted for code like
    /// ```text
    /// false = foo
    /// ```
    CantAssignToFalse {

    },
    /// Emitted for code like
    /// ```text
    /// __FILE__ = foo
    /// ```
    CantAssignToFile {

    },
    /// Emitted for code like
    /// ```text
    /// __LINE__ = foo
    /// ```
    CantAssignToLine {

    },
    /// Emitted for code like
    /// ```text
    /// __ENCODING__ = foo
    /// ```
    CantAssignToEncoding {

    },
    /// Emitted for code like
    /// ```text
    /// proc {_1; _1 = nil}
    /// ```
    CantAssignToNumparam {
        /// Source of the numbered parameter
        numparam: String,
    },
    /// Emitted for code like
    /// ```text
    /// $1 = foo
    /// ```
    CantSetVariable {
        /// Source of the read-only variable that is assigned
        var_name: String,
    },
    /// Emitted for code like
    /// ```text
    /// yield(&foo)
    /// ```
    BlockGivenToYield {

    },
    /// Emitted for code like
    /// ```text
    /// fun(&bar) do end
    /// ```
    BlockAndBlockArgGiven {

    },
    /// Emitted for code like
    /// ```text
    /// case a; in "#{a}": 1; end
    /// ```
    SymbolLiteralWithInterpolation {

    },
    /// Emitted for code like
    /// ```text
    /// _1 = 1
    /// ```
    ReservedForNumparam {
        /// Numbered parameter that is treated as a local variable
        numparam: String,
    },
    /// Emitted for code like
    /// ```text
    /// case a; in a?:; end
    /// ```
    KeyMustBeValidAsLocalVariable {

    },
    /// Emitted for code like
    /// ```text
    /// case 0; in a, a; end
    /// ```
    DuplicateVariableName {

    },
    /// Emitted for code like
    /// ```text
    /// case 0; in a: 1, a: 2; end
    /// ```
    DuplicateKeyName {

    },
    /// Emitted for code like
    /// ```text
    /// def (1).foo; end
    /// ```
    SingletonLiteral {

    },
    /// Emitted for code like (only in $VERBOSE mode)
    /// ```text
    /// $100
    /// ```
    NthRefIsTooBig {
        /// Source of the nth_ref that is techincally a regular global variable
        nth_ref: String,
    },
    /// Emitted for code like
    /// ```text
    /// def foo(aa, aa); end
    /// ```
    DuplicatedArgumentName {

    },
    /// Emitted for code like
    /// ```text
    /// /[/
    /// ```
    RegexError {
        /// Error from Onigurama engine
        error: String,
    },
    /// Emitted for code like
    /// ```text
    /// %I"x .\xc3."
    /// ```
    InvalidSymbol {
        /// Source of the symbol
        symbol: String,
    },
    /// Emitted for code like
    /// ```text
    /// a = return
    /// ```
    VoidValueExpression {

    },
}
