use crate::codegen::rust::nodes::helpers::filename;
use lib_ruby_parser_nodes::{template::*, Node};

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

{{ each node }}<dnl>
mod {{ helper mod-name }};
{{ end }}

{{ each node }}<dnl>
pub use {{ helper mod-name }}::{{ helper node-camelcase-name }};
{{ end }}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register::<Node, F::Helper>("mod-name", filename);

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/nodes/types/mod.rs", contents).unwrap();
}
