// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `super` call without arguments and parentheses
///
/// It's different from `super()` as it implicitly forwards current arguments
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ZSuper {
    /// Location of the `super` keyword
    ///
    /// ```text
    /// super
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl ZSuper {
    // getters

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalZSuper {
        let Self { expression_l,  } = self;
        super::InternalZSuper { expression_l,  }
    }
}

impl InnerNode for ZSuper {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "zsuper"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}
