// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `while` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct While {
    /// Condition of the loop
    pub cond: Box<Node>,

    /// Body of the loop.
    ///
    /// `None` if body is empty
    pub body: Option<Box<Node>>,

    /// Location of the `while` keyword
    ///
    /// ```text
    /// while cond do; foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// while cond do; foo; end
    ///            ~~
    /// ```
    ///
    /// `do` is optional, and so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// while cond do; foo; end
    ///                     ~~~
    /// ```
    ///
    /// `None` if loop is a modifier (i.e. `foo while bar`)
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// while cond do; foo; end
    /// ~~~~~~~~~~~~~~~~~~~~~~~
    ///
    /// foo while bar
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl While {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalWhile {
        let Self { cond, body, keyword_l, begin_l, end_l, expression_l,  } = self;
        super::InternalWhile { cond, body, keyword_l, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for While {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "while"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
