// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a post-until loop
///
/// ```text
/// begin
/// foo
/// end until bar
/// ```
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct UntilPost {
    /// Condition of the loop
    pub cond: Box<Node>,

    /// Body of the loop
    pub body: Box<Node>,

    /// Location of the `until` keyword
    ///
    /// ```text
    /// begin; foo; end until bar
    ///                 ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `until` keyword
    ///
    /// ```text
    /// begin; foo; end until bar
    /// ~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl UntilPost {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Box<Node> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Box<Node>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalUntilPost {
        let Self { cond, body, keyword_l, expression_l,  } = self;
        super::InternalUntilPost { cond, body, keyword_l, expression_l,  }
    }
}

impl InnerNode for UntilPost {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_node(self.get_body());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "until_post"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_body().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
