// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Bytes;

/// Represents a plain non-interpolated string literal (e.g. `"foo"`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Str {
    /// Value of the string literal
    ///
    /// Note that it's a `StringValue`, not a `String`.
    /// The reason is that you can get UTF-8 incompatible strings
    /// from a valid UTF-8 source using escape sequences like `"\xFF"`
    ///
    /// These "\", "x", "F", "F" chars are valid separately, but together
    /// they construct a char with code = 255 that is invalid for UTF-8.
    ///
    /// You can use `to_string_lossy` or `to_string` methods to get a raw string value.
    pub value: Bytes,

    /// Location of the string begin
    ///
    /// ```text
    /// "foo"
    /// ~
    /// ```
    ///
    /// `None` if string literal is a part of the words array (like `%w[foo bar baz]`)
    pub begin_l: Option<Loc>,

    /// Location of the string begin
    ///
    /// ```text
    /// "foo"
    ///     ~
    /// ```
    ///
    /// `None` if string literal is a part of the words array (like `%w[foo bar baz]`)
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// "foo"
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Str {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &Bytes {
        &self.value
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: Bytes) {
        self.value = value;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalStr {
        let Self { value, begin_l, end_l, expression_l,  } = self;
        super::InternalStr { value, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Str {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_string_value(self.get_value());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "str"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
