// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special block argument that "shadows" outer variable (i.e. `|;foo|`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Shadowarg {
    /// Name of the argument
    pub name: String,

    /// Location of the argument
    ///
    /// ```text
    /// proc { |;foo|}
    ///          ~~~
    /// ```
    pub expression_l: Loc,

}

impl Shadowarg {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalShadowarg {
        let Self { name, expression_l,  } = self;
        super::InternalShadowarg { name, expression_l,  }
    }
}

impl InnerNode for Shadowarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "shadowarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_expression_l().print("expression");
    }
}
