// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents opening a singleton class (i.e. `class << foo; ... end;`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct SClass {
    /// Expression that is used to get a singleton class
    ///
    /// `Lvar("foo")` for `class << foo; end`
    pub expr: Box<Node>,

    /// Body of the block
    pub body: Option<Box<Node>>,

    /// Location of the `class` keyword
    ///
    /// ```text
    /// class << foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `<<` operator
    ///
    /// ```text
    /// class << foo; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// class << foo; end
    ///               ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// class << foo; end
    /// ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl SClass {
    // getters

    /// Returns `expr` field
    pub fn get_expr(&self) -> &Box<Node> {
        &self.expr
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `expr` field
    pub fn set_expr(&mut self, expr: Box<Node>) {
        self.expr = expr;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSClass {
        let Self { expr, body, keyword_l, operator_l, end_l, expression_l,  } = self;
        super::InternalSClass { expr, body, keyword_l, operator_l, end_l, expression_l,  }
    }
}

impl InnerNode for SClass {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_expr());
        result.push_maybe_node_or_nil(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "sclass"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expr().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_operator_l().print("operator");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
