// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `BEGIN { ... }` statement
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Preexe {
    /// Body of the block
    pub body: Option<Box<Node>>,

    /// Location of the `BEGIN` keyword
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///       ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Preexe {
    // getters

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPreexe {
        let Self { body, keyword_l, begin_l, end_l, expression_l,  } = self;
        super::InternalPreexe { body, keyword_l, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Preexe {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "preexe"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
