// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalPostexe;
use crate::blobs::{HasBlob, Blob};

/// Represents `END { .. }` statement
#[repr(C)]
pub struct Postexe {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Postexe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Postexe")
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Postexe {
    fn eq(&self, other: &Self) -> bool {
        if self.get_body() != other.get_body() {
            return false
        }
        if self.get_keyword_l() != other.get_keyword_l() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Postexe {
    // getters
    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__postexe__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__postexe__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__postexe__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__postexe__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__postexe__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__postexe__set_body(&mut self.blob, body.into_blob()) }
    }
    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__postexe__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__postexe__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__postexe__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__postexe__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalPostexe {
        unsafe { lib_ruby_parser__external__nodes__postexe__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__postexe__get_body(blob: *const Blob<Postexe>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__postexe__set_body(blob: *mut Blob<Postexe>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__postexe__get_keyword_l(blob: *const Blob<Postexe>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__postexe__set_keyword_l(blob: *mut Blob<Postexe>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__postexe__get_begin_l(blob: *const Blob<Postexe>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__postexe__set_begin_l(blob: *mut Blob<Postexe>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__postexe__get_end_l(blob: *const Blob<Postexe>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__postexe__set_end_l(blob: *mut Blob<Postexe>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__postexe__get_expression_l(blob: *const Blob<Postexe>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__postexe__set_expression_l(blob: *mut Blob<Postexe>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__postexe__into_internal(blob: Blob<Postexe>) -> InternalPostexe;
    fn lib_ruby_parser__external__nodes__postexe__drop(blob: *mut Blob<Postexe>);
}

impl InnerNode for Postexe {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(self.get_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "postexe"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Postexe {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__postexe__drop(&mut self.blob) }
    }
}
