// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalPin;
use crate::blobs::{HasBlob, Blob};

/// Represents a pattern based on a "pinned" variable (e.g. `^foo`)
#[repr(C)]
pub struct Pin {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Pin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Pin")
            .field("var", &self.get_var())
            .field("selector_l", &self.get_selector_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Pin {
    fn eq(&self, other: &Self) -> bool {
        if self.get_var() != other.get_var() {
            return false
        }
        if self.get_selector_l() != other.get_selector_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Pin {
    // getters
    /// Returns `var` field
    pub fn get_var(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pin__get_var(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `selector_l` field
    pub fn get_selector_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pin__get_selector_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pin__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `var` field
    pub fn set_var(&mut self, var: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__pin__set_var(&mut self.blob, var.into_blob()) }
    }
    /// Sets `selector_l` field
    pub fn set_selector_l(&mut self, selector_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__pin__set_selector_l(&mut self.blob, selector_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__pin__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalPin {
        unsafe { lib_ruby_parser__external__nodes__pin__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__pin__get_var(blob: *const Blob<Pin>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__pin__set_var(blob: *mut Blob<Pin>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__pin__get_selector_l(blob: *const Blob<Pin>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__pin__set_selector_l(blob: *mut Blob<Pin>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__pin__get_expression_l(blob: *const Blob<Pin>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__pin__set_expression_l(blob: *mut Blob<Pin>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__pin__into_internal(blob: Blob<Pin>) -> InternalPin;
    fn lib_ruby_parser__external__nodes__pin__drop(blob: *mut Blob<Pin>);
}

impl InnerNode for Pin {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_var());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_var().inner_ref().print_with_locs();
        self.get_selector_l().print("selector");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Pin {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__pin__drop(&mut self.blob) }
    }
}
