// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents optional positional argument (i.e. `foo` in `m(foo = 1)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Optarg {
    /// Name of the argument
    pub name: String,

    /// Default value of the argument
    pub default: Box<Node>,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(foo = 1); end
    ///       ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// def m(foo = 1); end
    ///           ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(foo = 1); end
    ///       ~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Optarg {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `default` field
    pub fn get_default(&self) -> &Box<Node> {
        &self.default
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `default` field
    pub fn set_default(&mut self, default: Box<Node>) {
        self.default = default;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalOptarg {
        let Self { name, default, name_l, operator_l, expression_l,  } = self;
        super::InternalOptarg { name, default, name_l, operator_l, expression_l,  }
    }
}

impl InnerNode for Optarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_node(self.get_default());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "optarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_default().inner_ref().print_with_locs();
        self.get_name_l().print("name");
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
