// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a block that takes numbered parameters (i.e. `proc { _1 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Numblock {
    /// Method call that takes a block
    pub call: Box<Node>,

    /// Number of parameters that block takes
    pub numargs: u8,

    /// Block body
    pub body: Box<Node>,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { _1 }
    ///      ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing brace
    ///
    /// ```text
    /// proc { _1 }
    ///           ~
    /// ```
    pub end_l: Loc,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { _1 }
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Numblock {
    // getters

    /// Returns `call` field
    pub fn get_call(&self) -> &Box<Node> {
        &self.call
    }

    /// Returns `numargs` field
    pub fn get_numargs(&self) -> &u8 {
        &self.numargs
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Box<Node> {
        &self.body
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `call` field
    pub fn set_call(&mut self, call: Box<Node>) {
        self.call = call;
    }

    /// Sets `numargs` field
    pub fn set_numargs(&mut self, numargs: u8) {
        self.numargs = numargs;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Box<Node>) {
        self.body = body;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalNumblock {
        let Self { call, numargs, body, begin_l, end_l, expression_l,  } = self;
        super::InternalNumblock { call, numargs, body, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Numblock {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_call());
        result.push_u8(self.get_numargs());
        result.push_node(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "numblock"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_call().inner_ref().print_with_locs();

        self.get_body().inner_ref().print_with_locs();
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
