// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents numeric global variable (e.g. `$1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct NthRef {
    /// Name of the variable, `String("1")` for `$1`
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// $1
    /// ~~
    /// ```
    pub expression_l: Loc,

}

impl NthRef {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalNthRef {
        let Self { name, expression_l,  } = self;
        super::InternalNthRef { name, expression_l,  }
    }
}

impl InnerNode for NthRef {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_raw_str(self.get_name());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nth_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_expression_l().print("expression");
    }
}
