// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `next` keyword
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Next {
    /// Arguments given to `next`
    pub args: Vec<Node>,

    /// Location of the `next` keyword
    ///
    /// ```text
    /// next 42
    /// ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// next(42)
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Next {
    // getters

    /// Returns `args` field
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `args` field
    pub fn set_args(&mut self, args: Vec<Node>) {
        self.args = args;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalNext {
        let Self { args, keyword_l, expression_l,  } = self;
        super::InternalNext { args, keyword_l, expression_l,  }
    }
}

impl InnerNode for Next {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "next"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() { node.inner_ref().print_with_locs(); }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
