// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a wildcard pattern used in pattern matching (i.e. `in *foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchRest {
    /// Name of the variable name
    ///
    /// `None` if there's no name (i.e. `in *`)
    pub name: Option<Box<Node>>,

    /// Location of the `*` operator
    ///
    /// ```text
    /// case foo; in *bar; end
    ///              ~
    /// ```
    pub operator_l: Loc,

    /// Location of the `*` operator
    ///
    /// ```text
    /// case foo; in *bar; end
    ///              ~~~~
    /// ```
    pub expression_l: Loc,

}

impl MatchRest {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &Option<Box<Node>> {
        &self.name
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: Option<Box<Node>>) {
        self.name = name;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchRest {
        let Self { name, operator_l, expression_l,  } = self;
        super::InternalMatchRest { name, operator_l, expression_l,  }
    }
}

impl InnerNode for MatchRest {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(self.get_name());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_rest"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_name().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
