// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a one-line pattern matching that never throws but returns true/false (i.e. `foo in pattern`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchPatternP {
    /// Value that is used for matching
    pub value: Box<Node>,

    /// Pattern that is used for matching
    pub pattern: Box<Node>,

    /// Location of the `in` operator
    ///
    /// ```text
    /// foo in pattern
    ///     ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo in pattern
    /// ~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl MatchPatternP {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Box<Node>) {
        self.pattern = pattern;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchPatternP {
        let Self { value, pattern, operator_l, expression_l,  } = self;
        super::InternalMatchPatternP { value, pattern, operator_l, expression_l,  }
    }
}

impl InnerNode for MatchPatternP {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());
        result.push_node(self.get_pattern());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_pattern_p"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_pattern().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
