// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents empty hash pattern that is used in pattern matching (i.e. `in **nil`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchNilPattern {
    /// Location of the `**` operator
    ///
    /// ```text
    /// in **nil
    ///    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// in **nil
    ///      ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// in **nil
    ///    ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl MatchNilPattern {
    // getters

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchNilPattern {
        let Self { operator_l, name_l, expression_l,  } = self;
        super::InternalMatchNilPattern { operator_l, name_l, expression_l,  }
    }
}

impl InnerNode for MatchNilPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_nil_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_operator_l().print("operator");
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}
