// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents matching with renaming into specified local variable (i.e. `case 1; in Integer => a; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchAs {
    /// Pattern that is used for matching
    pub value: Box<Node>,

    /// Variable that is assigned if matched (see `MatchVar` node)
    pub as_: Box<Node>,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///                    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///            ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl MatchAs {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `as_` field
    pub fn get_as(&self) -> &Box<Node> {
        &self.as_
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `as_` field
    pub fn set_as(&mut self, as_: Box<Node>) {
        self.as_ = as_;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchAs {
        let Self { value, as_, operator_l, expression_l,  } = self;
        super::InternalMatchAs { value, as_, operator_l, expression_l,  }
    }
}

impl InnerNode for MatchAs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());
        result.push_node(self.get_as());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_as"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_as().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
