// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalLvar;
use crate::blobs::{HasBlob, Blob};

/// Represents access to a local variable (i.e. `foo`)
///
/// Parser knows that it's a local variable because:
/// 1. there was an assignment to this variable **before** accessing it
/// 2. it's an argument of the current method / block
/// 3. it's been implicitly declared by `MatchWithLvasgn` node
///
/// Otherwise it's a method call (see `Send`)
#[repr(C)]
pub struct Lvar {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Lvar {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Lvar")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Lvar {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Lvar {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvar__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvar__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__lvar__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__lvar__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalLvar {
        unsafe { lib_ruby_parser__external__nodes__lvar__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__lvar__get_name(blob: *const Blob<Lvar>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__lvar__set_name(blob: *mut Blob<Lvar>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__lvar__get_expression_l(blob: *const Blob<Lvar>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__lvar__set_expression_l(blob: *mut Blob<Lvar>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__lvar__into_internal(blob: Blob<Lvar>) -> InternalLvar;
    fn lib_ruby_parser__external__nodes__lvar__drop(blob: *mut Blob<Lvar>);
}

impl InnerNode for Lvar {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "lvar"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_expression_l().print("expression");
    }
}

impl Drop for Lvar {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__lvar__drop(&mut self.blob) }
    }
}
