// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a keyword rest argument (i.e. `foo` in `def m(**foo); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwrestarg {
    /// Name of the keyword rest argument, `String("foo")` in `def m(**foo); end`.
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name: Option<String>,

    /// Location of the `**` operator
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(**foo); end
    ///         ~~~
    /// ```
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Kwrestarg {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &Option<String> {
        &self.name
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Option<Loc> {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: Option<String>) {
        self.name = name;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Option<Loc>) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwrestarg {
        let Self { name, operator_l, name_l, expression_l,  } = self;
        super::InternalKwrestarg { name, operator_l, name_l, expression_l,  }
    }
}

impl InnerNode for Kwrestarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_str(self.get_name());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwrestarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_operator_l().print("operator");
        if let Some(loc) = self.get_name_l().as_ref() { loc.print("name") }
        self.get_expression_l().print("expression");
    }
}
