// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalKwoptarg;
use crate::blobs::{HasBlob, Blob};

/// Represents an optional keyword argument (i.e. `foo` in `def m(foo: 42); end`)
#[repr(C)]
pub struct Kwoptarg {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Kwoptarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Kwoptarg")
            .field("name", &self.get_name())
            .field("default", &self.get_default())
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Kwoptarg {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_default() != other.get_default() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Kwoptarg {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwoptarg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `default` field
    pub fn get_default(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwoptarg__get_default(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwoptarg__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwoptarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `default` field
    pub fn set_default(&mut self, default: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__set_default(&mut self.blob, default.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwoptarg {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kwoptarg__get_name(blob: *const Blob<Kwoptarg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__kwoptarg__set_name(blob: *mut Blob<Kwoptarg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__kwoptarg__get_default(blob: *const Blob<Kwoptarg>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__kwoptarg__set_default(blob: *mut Blob<Kwoptarg>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__kwoptarg__get_name_l(blob: *const Blob<Kwoptarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwoptarg__set_name_l(blob: *mut Blob<Kwoptarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwoptarg__get_expression_l(blob: *const Blob<Kwoptarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwoptarg__set_expression_l(blob: *mut Blob<Kwoptarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwoptarg__into_internal(blob: Blob<Kwoptarg>) -> InternalKwoptarg;
    fn lib_ruby_parser__external__nodes__kwoptarg__drop(blob: *mut Blob<Kwoptarg>);
}

impl InnerNode for Kwoptarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_node(self.get_default());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwoptarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_default().inner_ref().print_with_locs();
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Kwoptarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kwoptarg__drop(&mut self.blob) }
    }
}
