// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents required keyword argument (i.e. `foo` in `def m(foo:); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwarg {
    /// Name of the keyword argument
    pub name: String,

    /// Location of the name
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~~
    /// ```
    pub expression_l: Loc,

}

impl Kwarg {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwarg {
        let Self { name, name_l, expression_l,  } = self;
        super::InternalKwarg { name, name_l, expression_l,  }
    }
}

impl InnerNode for Kwarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}
