// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an explicit `begin; end` block.
///
/// The reason why it's different is that
/// ```text
/// begin; foo; end while cond
/// ```
/// is a post-while loop (same with post-until loop)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct KwBegin {
    /// A list of statements
    pub statements: Vec<Node>,

    /// Location of the `begin` keyword
    ///
    /// ```text
    /// begin; foo; end
    /// ~~~~~
    /// ```
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// begin; foo; end
    ///             ~~~
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; foo; bar
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl KwBegin {
    // getters

    /// Returns `statements` field
    pub fn get_statements(&self) -> &Vec<Node> {
        &self.statements
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `statements` field
    pub fn set_statements(&mut self, statements: Vec<Node>) {
        self.statements = statements;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwBegin {
        let Self { statements, begin_l, end_l, expression_l,  } = self;
        super::InternalKwBegin { statements, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for KwBegin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_statements());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwbegin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_statements().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
