// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalList as List;

use super::internal::InternalKwBegin;
use crate::blobs::{HasBlob, Blob};

/// Represents an explicit `begin; end` block.
///
/// The reason why it's different is that
/// ```text
/// begin; foo; end while cond
/// ```
/// is a post-while loop (same with post-until loop)
#[repr(C)]
pub struct KwBegin {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for KwBegin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("KwBegin")
            .field("statements", &self.get_statements())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for KwBegin {
    fn eq(&self, other: &Self) -> bool {
        if self.get_statements() != other.get_statements() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl KwBegin {
    // getters
    /// Returns `statements` field
    pub fn get_statements(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kw_begin__get_statements(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kw_begin__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kw_begin__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kw_begin__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `statements` field
    pub fn set_statements(&mut self, statements: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__set_statements(&mut self.blob, statements.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwBegin {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kw_begin__get_statements(blob: *const Blob<KwBegin>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__kw_begin__set_statements(blob: *mut Blob<KwBegin>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__kw_begin__get_begin_l(blob: *const Blob<KwBegin>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__kw_begin__set_begin_l(blob: *mut Blob<KwBegin>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__kw_begin__get_end_l(blob: *const Blob<KwBegin>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__kw_begin__set_end_l(blob: *mut Blob<KwBegin>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__kw_begin__get_expression_l(blob: *const Blob<KwBegin>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kw_begin__set_expression_l(blob: *mut Blob<KwBegin>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kw_begin__into_internal(blob: Blob<KwBegin>) -> InternalKwBegin;
    fn lib_ruby_parser__external__nodes__kw_begin__drop(blob: *mut Blob<KwBegin>);
}

impl InnerNode for KwBegin {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_statements());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwbegin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_statements().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for KwBegin {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kw_begin__drop(&mut self.blob) }
    }
}
