// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents assignment using indexing operation (i.e. `foo[1, 2, 3] = bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IndexAsgn {
    /// Receiver of the indexing
    pub recv: Box<Node>,

    /// A list of indexes
    pub indexes: Vec<Node>,

    /// Value that is assigned
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case `value` belongs to `Masgn` node.
    pub value: Option<Box<Node>>,

    /// Location of open bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///    ~
    /// ```
    pub begin_l: Loc,

    /// Location of closing bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///              ~
    /// ```
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case operator `=` belongs to `Masgn` node.
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl IndexAsgn {
    // getters

    /// Returns `recv` field
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    /// Returns `indexes` field
    pub fn get_indexes(&self) -> &Vec<Node> {
        &self.indexes
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Box<Node>) {
        self.recv = recv;
    }

    /// Sets `indexes` field
    pub fn set_indexes(&mut self, indexes: Vec<Node>) {
        self.indexes = indexes;
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Option<Loc>) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIndexAsgn {
        let Self { recv, indexes, value, begin_l, end_l, operator_l, expression_l,  } = self;
        super::InternalIndexAsgn { recv, indexes, value, begin_l, end_l, operator_l, expression_l,  }
    }
}

impl InnerNode for IndexAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_nodes(self.get_indexes());
        result.push_maybe_node(self.get_value());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "indexasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();
        for node in self.get_indexes().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}
