// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `in pattern` branch of the pattern matching
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct InPattern {
    /// Value that is used for matching
    pub pattern: Box<Node>,

    /// Guard that is used for matching
    ///
    /// Optional, so can be `None`
    pub guard: Option<Box<Node>>,

    /// Body of the branch that is invoked if value matches pattern
    pub body: Option<Box<Node>>,

    /// Location of the `in` keyword
    ///
    /// ```text
    /// case value; in pattern; end
    ///             ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// case value; in pattern then; end
    ///                        ~~~~
    /// ```
    pub begin_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case value; in pattern then; 42; end
    ///             ~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InPattern {
    // getters

    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    /// Returns `guard` field
    pub fn get_guard(&self) -> &Option<Box<Node>> {
        &self.guard
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Box<Node>) {
        self.pattern = pattern;
    }

    /// Sets `guard` field
    pub fn set_guard(&mut self, guard: Option<Box<Node>>) {
        self.guard = guard;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalInPattern {
        let Self { pattern, guard, body, keyword_l, begin_l, expression_l,  } = self;
        super::InternalInPattern { pattern, guard, body, keyword_l, begin_l, expression_l,  }
    }
}

impl InnerNode for InPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_pattern());
        result.push_maybe_node_or_nil(self.get_guard());
        result.push_maybe_node_or_nil(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "in_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_pattern().inner_ref().print_with_locs();
        if let Some(node) = self.get_guard().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_expression_l().print("expression");
    }
}
