// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents ternary `if` statement (i.e. `cond ? if_true : if_false`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfTernary {
    /// Condition of the `if` statement
    pub cond: Box<Node>,

    /// True-branch
    pub if_true: Box<Node>,

    /// True-branch
    pub if_false: Box<Node>,

    /// Location of the `?` operator
    ///
    /// ```text
    /// cond ? if_true : if_false
    ///      ~
    /// ```
    pub question_l: Loc,

    /// Location of the `:` operator
    ///
    /// ```text
    /// cond ? if_true : if_false
    ///                ~
    /// ```
    pub colon_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// cond ? if_true : if_false
    /// ~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl IfTernary {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &Box<Node> {
        &self.if_true
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &Box<Node> {
        &self.if_false
    }

    /// Returns `question_l` field
    pub fn get_question_l(&self) -> &Loc {
        &self.question_l
    }

    /// Returns `colon_l` field
    pub fn get_colon_l(&self) -> &Loc {
        &self.colon_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: Box<Node>) {
        self.if_true = if_true;
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: Box<Node>) {
        self.if_false = if_false;
    }

    /// Sets `question_l` field
    pub fn set_question_l(&mut self, question_l: Loc) {
        self.question_l = question_l;
    }

    /// Sets `colon_l` field
    pub fn set_colon_l(&mut self, colon_l: Loc) {
        self.colon_l = colon_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIfTernary {
        let Self { cond, if_true, if_false, question_l, colon_l, expression_l,  } = self;
        super::InternalIfTernary { cond, if_true, if_false, question_l, colon_l, expression_l,  }
    }
}

impl InnerNode for IfTernary {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_node(self.get_if_true());
        result.push_node(self.get_if_false());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_if_true().inner_ref().print_with_locs();
        self.get_if_false().inner_ref().print_with_locs();
        self.get_question_l().print("question");
        self.get_colon_l().print("colon");
        self.get_expression_l().print("expression");
    }
}
