// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if`/`unless` modifier (i.e. `stmt if cond`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfMod {
    /// Condition of the modifier
    pub cond: Box<Node>,

    /// True-branch of the modifier.
    ///
    /// Always set for `if` modifier.
    /// Always `None` for `unless` modifier.
    pub if_true: Option<Box<Node>>,

    /// False-branch of the modifier.
    ///
    /// Always set for `unless` modifier.
    /// Always `None` for `if` modifier.
    pub if_false: Option<Box<Node>>,

    /// Location of the `if`/`unless` keyword
    ///
    /// ```text
    /// stmt if cond
    ///      ~~
    ///
    /// stmt unless cond
    ///      ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// stmt if cond
    /// ~~~~~~~~~~~~
    ///
    /// stmt unless cond
    /// ~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl IfMod {
    // getters

    /// Returns `cond` field
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &Option<Box<Node>> {
        &self.if_true
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &Option<Box<Node>> {
        &self.if_false
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Box<Node>) {
        self.cond = cond;
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: Option<Box<Node>>) {
        self.if_true = if_true;
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: Option<Box<Node>>) {
        self.if_false = if_false;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIfMod {
        let Self { cond, if_true, if_false, keyword_l, expression_l,  } = self;
        super::InternalIfMod { cond, if_true, if_false, keyword_l, expression_l,  }
    }
}

impl InnerNode for IfMod {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_maybe_node_or_nil(self.get_if_true());
        result.push_maybe_node_or_nil(self.get_if_false());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        if let Some(node) = self.get_if_true().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_if_false().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
