// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents inclusive flip-flop (i.e. in `if foo..bar; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IFlipFlop {
    /// Left part of the flip-flop. `None` if based on a range without begin (`..bar`)
    pub left: Option<Box<Node>>,

    /// Right part of the flip-flop. `None` if based on a range without end (`foo..`)
    pub right: Option<Box<Node>>,

    /// Location of the `..` operator
    ///
    /// ```text
    /// if foo..bar; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// if foo..bar; end
    ///    ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl IFlipFlop {
    // getters

    /// Returns `left` field
    pub fn get_left(&self) -> &Option<Box<Node>> {
        &self.left
    }

    /// Returns `right` field
    pub fn get_right(&self) -> &Option<Box<Node>> {
        &self.right
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `left` field
    pub fn set_left(&mut self, left: Option<Box<Node>>) {
        self.left = left;
    }

    /// Sets `right` field
    pub fn set_right(&mut self, right: Option<Box<Node>>) {
        self.right = right;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIFlipFlop {
        let Self { left, right, operator_l, expression_l,  } = self;
        super::InternalIFlipFlop { left, right, operator_l, expression_l,  }
    }
}

impl InnerNode for IFlipFlop {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_left());
        result.push_maybe_node_or_nil(self.get_right());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "iflipflop"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_left().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_right().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
