// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a hash pattern used in pattern matching (i.e. `in { a: 1 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct HashPattern {
    /// A list of inner patterns
    pub elements: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///              ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///                     ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///              ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl HashPattern {
    // getters

    /// Returns `elements` field
    pub fn get_elements(&self) -> &Vec<Node> {
        &self.elements
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `elements` field
    pub fn set_elements(&mut self, elements: Vec<Node>) {
        self.elements = elements;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalHashPattern {
        let Self { elements, begin_l, end_l, expression_l,  } = self;
        super::InternalHashPattern { elements, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for HashPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_elements());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_elements().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
