// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalList as List;

use super::internal::InternalHash;
use crate::blobs::{HasBlob, Blob};

/// Represents a hash literal (i.e. `{ foo: 42 }`)
#[repr(C)]
pub struct Hash {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Hash {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Hash")
            .field("pairs", &self.get_pairs())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Hash {
    fn eq(&self, other: &Self) -> bool {
        if self.get_pairs() != other.get_pairs() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Hash {
    // getters
    /// Returns `pairs` field
    pub fn get_pairs(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_pairs(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `pairs` field
    pub fn set_pairs(&mut self, pairs: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_pairs(&mut self.blob, pairs.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalHash {
        unsafe { lib_ruby_parser__external__nodes__hash__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__hash__get_pairs(blob: *const Blob<Hash>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__hash__set_pairs(blob: *mut Blob<Hash>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__hash__get_begin_l(blob: *const Blob<Hash>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__hash__set_begin_l(blob: *mut Blob<Hash>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__hash__get_end_l(blob: *const Blob<Hash>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__hash__set_end_l(blob: *mut Blob<Hash>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__hash__get_expression_l(blob: *const Blob<Hash>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__hash__set_expression_l(blob: *mut Blob<Hash>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__hash__into_internal(blob: Blob<Hash>) -> InternalHash;
    fn lib_ruby_parser__external__nodes__hash__drop(blob: *mut Blob<Hash>);
}

impl InnerNode for Hash {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_pairs());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_pairs().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Hash {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__hash__drop(&mut self.blob) }
    }
}
